<?php

namespace App\Http\Controllers;

use App\Models\Evaluation;
use Illuminate\Http\Request;
use App\Http\Requests\StoreEvaluationRequest;
use App\Http\Requests\UpdateEvaluationRequest;
use App\Models\EvaluationValue;
use App\Models\StudentSubscribe;
use App\Models\UploadedEvaluation;

class EvaluationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $evaluations =  Evaluation::get();
        return view('evaluations.list')->with('evaluations', $evaluations);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Http\Requests\StoreEvaluationRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreEvaluationRequest $request)
    {
        $request->validate([
            'name' => 'required',
            'type' => 'required',
        ], [
            'name.required' => 'يرجى اضافة نقطة التقييم .',
            'type.required' => 'يرجى اختيار نوع التقييم .'
        ]);
        try {

            $newEvaluation = new Evaluation();
            $newEvaluation->name = $request->name;
            $newEvaluation->type = $request->type;
            $newEvaluation->save();
            if($request->type==1)
          {  $evaluationValue = new EvaluationValue();
            $evaluationValue->evaluation_id = $newEvaluation->id;
            $evaluationValue->name = $request->name;
            $evaluationValue->save();
        }
        
            return back()->with(['success' => 'تم إضافة نقطة التقييم بنجاح     ']);
        } catch (\Throwable$th) {
            return back()->with(['error' => 'لم يتم إضافة  نقطة التقييم بنجاح   ']);
        }
    }

  
    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Evaluation  $evaluation
     * @return \Illuminate\Http\Response
     */
    public function show($subscriberId)
    {
        try {

            // $is_uploaded = UploadedEvaluation::where('subscribe_id', $subscriberId)->first();
            // if (isset($is_uploaded))
            //     return redirect()->route('user_dash')->with(['info' => 'لقد قمت بتعبئة هذا الاستبيان من قبل']);

            $evaluations = Evaluation::get();
            $subscriber = StudentSubscribe::find($subscriberId);
            return view('questionnaire.questionnaire')->with([
                'subscriber' => $subscriber,
                'evaluations' => $evaluations,
            ]);
        } catch (\Throwable $th) {
            return back()->with('error', 'عذرا هناك خطأ لا يمكن فتح هذا الاستبيان');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Evaluation  $evaluation
     * @return \Illuminate\Http\Response
     */
    public function edit(Evaluation $evaluation)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateEvaluationRequest  $request
     * @param  \App\Models\Evaluation  $evaluation
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateEvaluationRequest $request, Evaluation $evaluation)
    {
        $request->validate([
            'name' => 'required',
            'type' => 'required',
        ], [
            'name.required' => 'يرجى اضافة نقطة التقييم .',
            'type.required' => 'يرجى اختيار نوع التقييم .'
        ]);
        try {
            $updateEvaluation = Evaluation::find($request->id);
            $updateEvaluation->name = $request->name;
            $updateEvaluation->type = $request->type;
            $updateEvaluation->update();
            return back()->with(['success' => 'تم تحديث بيانات المتدرب بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات ']);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Evaluation  $evaluation
     * @return \Illuminate\Http\Response
     */
    public function destroy(Evaluation $evaluation, Request $request)
    {
        try {
            Evaluation::find($request->id)->delete();
            return back()->with(['success' => 'تمت حذف نقطة التقييم بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم حذف نقطة التقييم ']);
        }
    }
    /**
     * [Active and not active ]
     *
     * @param Request $request
     *
     * @return [type]
     *
     */
    public function toggle(Request $request)
    {
        try {
            $student = Evaluation::find($request->id);
            $student->is_active *= -1;
            $student->save();
            return back()->with(['success' => 'تمت تحديث البيانات بنجاح']);
        } catch (\Throwable $th) {
            return back()->with(['error' => 'لم يتم تحديث البيانات']);
        }
    }
}
